<?php

namespace horstoeko\zugferd\tests\testcases;

use horstoeko\zugferd\tests\TestCase;
use horstoeko\zugferd\ZugferdDocumentReader;
use horstoeko\zugferd\ZugferdDocumentValidator;

class ValidatorInvalidTest extends TestCase
{
    /**
     * The document instance
     *
     * @var ZugferdDocumentReader
     */
    protected static $document;

    /**
     * The validator instance
     *
     * @var ZugferdDocumentValidator
     */
    protected static $validator;

    public static function setUpBeforeClass(): void
    {
        self::$document = ZugferdDocumentReader::readAndGuessFromFile(__DIR__ . "/../assets/xml_en16931_5.xml");
        self::$validator = new ZugferdDocumentValidator(self::$document);
    }

    public function testValidateDocument(): void
    {
        $validationResult = self::$validator->validateDocument();
        $this->assertCount(1, $validationResult);
        $this->assertArrayHasKey(0, $validationResult);
        $this->assertEquals("This value should not be null.", $validationResult[0]->getMessage());
        $this->assertEquals("supplyChainTradeTransaction.applicableHeaderTradeAgreement.sellerTradeParty", $validationResult[0]->getPropertyPath());
    }
}
