<?php
/*
 * ShipcloudAPIV1Lib
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace ShipcloudAPIV1Lib\Controllers;

use ShipcloudAPIV1Lib\APIException;
use ShipcloudAPIV1Lib\APIHelper;
use ShipcloudAPIV1Lib\Configuration;
use ShipcloudAPIV1Lib\Models;
use ShipcloudAPIV1Lib\Exceptions;
use ShipcloudAPIV1Lib\Http\HttpRequest;
use ShipcloudAPIV1Lib\Http\HttpResponse;
use ShipcloudAPIV1Lib\Http\HttpMethod;
use ShipcloudAPIV1Lib\Http\HttpContext;
use Unirest\Request;

/**
 * @todo Add a general description for this controller.
 */
class APIController extends BaseController {

    /**
     * @var APIController The reference to *Singleton* instance of this class
     */
    private static $instance;
    
    /**
     * Returns the *Singleton* instance of this class.
     * @return APIController The *Singleton* instance.
     */
    public static function getInstance()
    {
        if (null === static::$instance) {
            static::$instance = new static();
        }
        
        return static::$instance;
    }

    /**
     * If you want to create a shipment, this is the way to go!
     * @param  Models\CreatingAShipmentRequest $body     Required parameter: Example: 
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function createCreatingAShipment (
                $body) 
    {
        //the base uri for api requests
        $_queryBuilder = Configuration::$BASEURI;
        
        //prepare query string for API call
        $_queryBuilder = $_queryBuilder.'/shipments';

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl($_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => 'APIMATIC 2.0',
            'Accept'        => 'application/json',
            'content-type'  => 'application/json; charset=utf-8'
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::POST, $_headers, $_queryUrl);
        if($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::post($_queryUrl, $_headers, Request\Body::Json($body));

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse,$_httpContext);

        $mapper = $this->getJsonMapper();

        return $mapper->map($response->body, new Models\CreatingAShipmentResponse());
    }
        
    /**
     * You can get every piece of information we know about a shipment with this single call.
     * @param  double     $id     Required parameter: This is the ID of your shipment returned to you when creating a shipment
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function getAllInfos (
                $id) 
    {
        //the base uri for api requests
        $_queryBuilder = Configuration::$BASEURI;
        
        //prepare query string for API call
        $_queryBuilder = $_queryBuilder.'/shipments/{id}';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id' => $id,
            ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl($_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => 'APIMATIC 2.0',
            'Accept'        => 'application/json'
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::GET, $_headers, $_queryUrl);
        if($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::get($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse,$_httpContext);

        return $response->body;
    }
        
    /**
     * If you haven't already created a shipping label for your shipment, you can still adjust it's parameters using this call.
     * @param  double                       $id                        Required parameter: This is the ID of your shipment returned to you when creating a shipment
     * @param  string                       $zipCodeOptional           Required parameter: zip code
     * @param  string                       $number                    Required parameter: used to identify the package
     * @param  bool                         $createShippingLabel       Required parameter: determines if a shipping label should be created at the carrier (this means you will be charged)
     * @param  Models\UpdatingAShipmentRequest $body                      Required parameter: Example: 
     * @param  string                       $carrier                   Optional parameter: the carrier you want to use. Possible values are _"DHL", "UPS", "HERMES", "DPD"_
     * @param  string                       $to                        Optional parameter: object describing the receivers address
     * @param  string                       $company                   Optional parameter: the receivers company name
     * @param  string                       $firstName                 Optional parameter: the receivers first name
     * @param  string                       $lastName                  Optional parameter: the receivers last name
     * @param  string                       $careOf                    Optional parameter: name of the person that should be able to receive the package
     * @param  string                       $street                    Optional parameter: street name
     * @param  string                       $streetNo                  Optional parameter: house number
     * @param  string                       $city                      Optional parameter: city
     * @param  string                       $state                     Optional parameter: state
     * @param  string                       $country                   Optional parameter: country as ISO 3166-1 alpha-2 code
     * @param  string                       $package                   Optional parameter: object describing the package dimensions
     * @param  double                       $width                     Optional parameter: width of the package in cm
     * @param  double                       $length                    Optional parameter: length of the package in cm
     * @param  double                       $height                    Optional parameter: height of the package in cm
     * @param  double                       $weight                    Optional parameter: weight in kg
     * @return mixed response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function updateUpdatingAShipment (
                $id,
                $zipCodeOptional,
                $number,
                $createShippingLabel,
                $body,
                $carrier = NULL,
                $to = NULL,
                $company = NULL,
                $firstName = NULL,
                $lastName = NULL,
                $careOf = NULL,
                $street = NULL,
                $streetNo = NULL,
                $city = NULL,
                $state = NULL,
                $country = NULL,
                $package = NULL,
                $width = NULL,
                $length = NULL,
                $height = NULL,
                $weight = NULL) 
    {
        //the base uri for api requests
        $_queryBuilder = Configuration::$BASEURI;
        
        //prepare query string for API call
        $_queryBuilder = $_queryBuilder.'/shipments/{id}';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id'                    => $id,
            ));

        //process optional query parameters
        APIHelper::appendUrlWithQueryParameters($_queryBuilder, array (
            'zip_code(optional,'    => $zipCodeOptional,
            'number'                => $number,
            'create_shipping_label' => var_export($createShippingLabel, true),
            'carrier'               => $carrier,
            'to'                    => $to,
            'company'               => $company,
            'first_name'            => $firstName,
            'last_name'             => $lastName,
            'care_of'               => $careOf,
            'street'                => $street,
            'street_no'             => $streetNo,
            'city'                  => $city,
            'state'                 => $state,
            'country'               => $country,
            'package'               => $package,
            'width'                 => $width,
            'length'                => $length,
            'height'                => $height,
            'weight'                => $weight,
        ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl($_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'          => 'APIMATIC 2.0',
            'Accept'              => 'application/json',
            'content-type'        => 'application/json; charset=utf-8'
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::PUT, $_headers, $_queryUrl);
        if($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::put($_queryUrl, $_headers, Request\Body::Json($body));

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse,$_httpContext);

        $mapper = $this->getJsonMapper();

        return $mapper->map($response->body, new Models\UpdatingAShipmentResponse());
    }
        

}