<?php
/*
 * ShipcloudAPIV1Lib
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

use ShipcloudAPIV1Lib\APIException;
use ShipcloudAPIV1Lib\Exceptions;
use ShipcloudAPIV1Lib\APIHelper; 
use ShipcloudAPIV1Lib\Models;

class APIControllerTest extends PHPUnit_Framework_TestCase {
    
    /**
     * @var \ShipcloudAPIV1Lib\Controllers\APIController Controller instance
     */
    protected static $controller;

    /**
     * @var HttpCallBackCatcher Callback
     */
    protected $httpResponse;

    /**
     * Setup test class
     */
    public static function setUpBeforeClass()
    {
        $client = new ShipcloudAPIV1Lib\ShipcloudAPIV1Client();
        self::$controller = $client->getClient();	
    }

    /**
     * Setup test
     */
    protected function setUp()
    {
        $this->httpResponse = new HttpCallBackCatcher();
    }

    /**
     * If you want to create a shipment, this is the way to go!
     */
    public function testCreatingAShipment1() {
        // Parameters for the API call
        $body = APIHelper::deserialize('{    "to": {        "company": "Receiver Inc.",        "first_name": "Max",        "last_name": "Mustermann",        "street": "Beispielstrasse",        "street_no": "42",        "city": "Hamburg",        "zip_code": "22100"    },    "package": {        "weight": 1.5,        "length": 20,        "width": 20,        "height": 20    },    "carrier": "dhl",    "reference_number": "ref123456",    "create_shipping_label": true}', new Models\CreatingAShipmentRequest());

        // Set callback and perform API call
        $result = null;
        self::$controller->setHttpCallBack($this->httpResponse);
        try {
        	$result = self::$controller->createCreatingAShipment($body);
        } catch(APIException $e) {};

        // Test response code
        $this->assertEquals(200, $this->httpResponse->getResponse()->getStatusCode(),
            "Status is not 200");

        // Test headers
        $headers = [];
        $headers['Content-Type'] = null ;
        
        $this->assertTrue(TestHelper::areHeadersProperSubsetOf($headers, $this->httpResponse->getResponse()->getHeaders(), true),
            "Headers do not match");

        // Test whether the captured response is as we expected
        $this->assertNotNull($result,
            "Result does not exist");

        $this->assertEquals('{    "id": "3a186c51d4281acbecf5ed38805b1db92a9d668b",    "carrier_tracking_no": "84168117830018",    "tracking_url": "http://track.shipcloud.io/3a186c51d4",    "label_url": "http://api.shipcloud.io/shipping_label_3a186c51d4.pdf",    "price": 3.4}', 
                $this->httpResponse->getResponse()->getRawBody(),
                "Response body does not match exactly");
    }

}
