<?php
/*
 #########################################################################
 #                       xt:Commerce Shopsoftware
 # ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 #
 # Copyright 2021 xt:Commerce GmbH All Rights Reserved.
 # This file may not be redistributed in whole or significant part.
 # Content of this file is Protected By International Copyright Laws.
 #
 # ~~~~~~ xt:Commerce Shopsoftware IS NOT FREE SOFTWARE ~~~~~~~
 #
 # https://www.xt-commerce.com
 #
 # ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 #
 # @copyright xt:Commerce GmbH, www.xt-commerce.com
 #
 # ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 #
 # xt:Commerce GmbH, Maximilianstrasse 9, 6020 Innsbruck
 #
 # office@xt-commerce.com
 #
 #########################################################################
 */

defined('_VALID_CALL') or die('Direct Access is not allowed.');

class meta_tags {

	public $minWordlength = _SYSTEM_METATAGS_WORDLENGTH;
	public $maxMetaKeyLength = _SYSTEM_METATAGS_MAXLENGTH;
	public $maxMetaKeyCount = _SYSTEM_METATAGS_MAXCOUNT;
	public $PageContent = '';
    /**
     * @var mixed|string
     */
    public mixed $pageTitle;
    /**
     * @var array|mixed
     */
    public mixed $tags;
    /**
     * @var false
     */
    public bool $autogenerate;

    function __construct() {
		global $language,$p_info;

		$this->tags = array ();
		$this->tags['robots'] = _STORE_META_ROBOTS;
		$this->tags['language'] = $language->code;
		$this->tags['company'] = _STORE_META_COMPANY;
		$this->tags['publisher'] = _STORE_META_PUBLISHER;
		$this->tags['description'] = _STORE_META_DESCRIPTION;
		$this->tags['keywords'] = _STORE_META_KEYWORDS;
		$this->pageTitle = defined('_STORE_NAME') ? constant('_STORE_NAME'):'NODEF_STORE_NAME';
        $this->autogenerate = false;
		$this->generateTags();
	}

	function generateTags()
	{
		global $xtPlugin, $page;

		switch ($page->page_name)
		{
			case 'product' :
				global $p_info;

				if ( ! empty($p_info->data['meta_keywords']))
				{
					$this->tags['keywords'] = $p_info->data['meta_keywords'];
				}
				elseif (_SYSTEM_METATAGS_AUTOGENERATE === 'true' && ! empty($p_info->data['products_description']))
				{
					$this->tags['keywords'] = $this->_autoGenerateTags($p_info->data['products_description']);
				}

				if ( ! empty($p_info->data['meta_title']))
				{
					$this->pageTitle = $p_info->data['meta_title'];
				}
				else
				{
					$this->pageTitle = $p_info->data['products_name'].'-'.$p_info->data['products_model'];
				}

				if ( ! empty($p_info->data['meta_description']))
				{
					$this->tags['description'] = $p_info->data['meta_description'];
				}
				elseif (_SYSTEM_METATAGS_AUTOGENERATE === 'true' && ! empty($p_info->data['products_description']))
				{
					$this->tags['description'] =  $this->_autoGenerateDescription($p_info->data['products_description']);
				}
				break;
			case 'categorie':
				global $category;

				if ( ! empty($category->current_category_data['meta_keywords']))
				{
					$this->tags['keywords'] = $category->current_category_data['meta_keywords'];
				}
				elseif (_SYSTEM_METATAGS_AUTOGENERATE === 'true' && ! empty($category->current_category_data['categories_description']))
				{
					$this->tags['keywords'] = $this->_autoGenerateTags($category->current_category_data['categories_description']);
				}

				if ( ! empty($category->current_category_data['meta_title']))
				{
					$this->pageTitle = $category->current_category_data['meta_title'];
				}
				else
				{
					$this->pageTitle = $category->current_category_data['categories_name'];
				}

				if ( ! empty($category->current_category_data['meta_description']))
				{
					$this->tags['description'] = $category->current_category_data['meta_description'];
				}
				elseif (_SYSTEM_METATAGS_AUTOGENERATE === 'true' && ! empty($category->current_category_data['categories_description']))
				{
					$this->tags['description'] =  $this->_autoGenerateDescription($category->current_category_data['categories_description']);
				}
				elseif (empty($category->current_category_data['categories_description'])) {
					$this->tags['description'] = '';
				}
				break;
			case 'content';
				global $_content,$current_content_id;

				$shop_content_data = $_content->getHookContent($current_content_id, 'true');
				$this->pageTitle = empty($shop_content_data['meta_title'])
					? $shop_content_data['title']
					: $shop_content_data['meta_title'];

				if ( ! empty($shop_content_data['meta_keywords']))
				{
					$this->tags['keywords'] = $shop_content_data['meta_keywords'];
				}
				elseif(_SYSTEM_METATAGS_AUTOGENERATE === 'true' && ! empty($shop_content_data['content_body']))
				{
					$this->tags['keywords'] = $this->_autoGenerateTags($shop_content_data['content_body']);
				}

				if ( ! empty($shop_content_data['meta_description']))
				{
					$this->tags['description'] = $shop_content_data['meta_description'];
				}
				elseif(_SYSTEM_METATAGS_AUTOGENERATE === 'true' && ! empty($shop_content_data['content_body']))
				{
					$this->tags['description'] = $this->_autoGenerateDescription($shop_content_data['content_body']);
				}
				break;
			case 'manufacturers':
				global $man_data, $current_manufacturer_id, $manufacturer;

				$man_data = $manufacturer->getManufacturerData($current_manufacturer_id);

				$this->pageTitle = empty($man_data['meta_title'])
					? $man_data['manufacturers_name']
					: $man_data['meta_title'];

				if ( ! empty($man_data['meta_keywords']))
				{
					$this->tags['keywords'] = $man_data['meta_keywords'];
				}
				elseif (_SYSTEM_METATAGS_AUTOGENERATE === 'true' && ! empty($man_data['manufacturers_description']))
				{
					$this->tags['keywords'] = $this->_autoGenerateTags($man_data['manufacturers_description']);
				}

				if ( ! empty($man_data['meta_description']))
				{
					$this->tags['description'] = $man_data['meta_description'];
				}
				elseif (_SYSTEM_METATAGS_AUTOGENERATE === 'true' && ! empty($man_data['manufacturers_description']))
				{
					$this->tags['description'] = $this->_autoGenerateDescription($man_data['manufacturers_description']);
				}
				break;
            case 'search':
                $this->tags['robots'] = 'noindex,follow';
                break;
            case 'cart':
                $this->pageTitle = __text('TEXT_CART');
                if (_STORE_META_KEYWORDS=='') $this->tags['keywords'] = $this->_autoGenerateTags($this->PageContent);
                break;
            case 'checkout':
                global $page;
                switch($page->page_action)
                {
                    case 'shipping':
                        $this->pageTitle = __text('TEXT_SELECT_SHIPPING');
                        break;
                    case 'payment':
                        $this->pageTitle = __text('TEXT_SELECT_PAYMENT');
                        break;
                    case 'confirmation':
                        $this->pageTitle = __text('TEXT_CONFIRMATION');
                        break;
                    case 'success':
                        $this->pageTitle = __text('TEXT_SUCCESS');
                        break;
                }
                if (_STORE_META_KEYWORDS=='') $this->tags['keywords'] = $this->_autoGenerateTags($this->PageContent);
                break;
			default :
				if (_STORE_META_KEYWORDS=='') $this->tags['keywords'] = $this->_autoGenerateTags($this->PageContent);
				break;
		}

		if (!empty($_GET['plugin']))
		{
			global $plugin_data, $seo_plugin;

			require_once _SRV_WEBROOT.'/xtFramework/classes/class.seo_plugins.php';

			$seo_plugin = new seo_plugins();
			$plugin_data = $seo_plugin->getPluginData($_GET['plugin']);

			if ( ! empty($plugin_data['meta_title']))
			{
				$this->pageTitle = $plugin_data['meta_title'];
			}

			if ( ! empty($plugin_data['meta_keywords']))
			{
				$this->tags['keywords'] = $plugin_data['meta_keywords'];
			}

			if ( ! empty($plugin_data['meta_description']))
			{
				$this->tags['description'] = $plugin_data['meta_description'];
			}
		}

		// meta tags im loginAs modus
		if ( ! empty($_SESSION['orderEditAdminUser']))
		{
			$customer = $_SESSION['customer'];
			$name = '';
			if(isset($customer->customer_default_address['customers_firstname']))
                $name = $customer->customer_default_address['customers_firstname']. ' ';
            if(isset($customer->customer_default_address['customers_lastname']))
                $name .= $customer->customer_default_address['customers_lastname'];
			$this->pageTitle = __text('TEXT_ORDER_EDIT_NEW_ORDER'). (!empty($name) ? ' - '.$name : '');
		}

		($plugin_code = $xtPlugin->PluginCode('class.meta_tags.php:'.__METHOD__.'_bottom')) ? eval ($plugin_code) : false;
	}

	function _showTags($page_content='') {
        global $xtPlugin, $page,$no_index_tag;
        //	echo $page->page_name;
        $this->PageContent=$page_content;
        
        $pagination = false;
        if(isset($_GET['next_page']) && $_GET['next_page']>1){
            $pagination = true;
        }
        $sorting=false;
        if (isset($_GET['sorting'])) {
            $sorting=true;
        }
        
        if ($no_index_tag) {
           $this->tags['robots'] = 'noindex';
        }elseif(_STORE_META_PAGINATION_ROBOTS !='true' && ($pagination == true || $sorting==true)){
               $this->tags['robots'] = 'noindex,follow';
        }
        
        if ($this->autogenerate && _SYSTEM_METATAGS_AUTOGENERATE=='true') {
            $this->tags['keywords'] = $this->_autoGenerateTags($this->PageContent);
        }

        ($plugin_code = $xtPlugin->PluginCode('class.meta_tags.php:_showTags_bottom')) ? eval ($plugin_code) : false;
        
        echo '<title>' . htmlspecialchars(htmlspecialchars_decode($this->pageTitle)) . "</title>\n";
        
        ($plugin_code = $xtPlugin->PluginCode('class.meta_tags.php:icra')) ? eval ($plugin_code) : false;


        foreach ($this->tags as $name => $content) {
           if (!empty ($content))
		   {
				if ($name =='language') 
				{
					if (_STORE_META_DOCTYPE_HTML!='html5') echo '<meta name="' . $name . '" content="' . htmlspecialchars($this->unhtmlentities($content)) . '" />' . "\n";
				}
				else echo '<meta name="' . $name . '" content="' . htmlspecialchars($this->unhtmlentities($content)) . '" />' . "\n";
			}
        }

        echo '<meta name="generator" content="xt:Commerce '._SYSTEM_VERSION.'" />' . "\n";
        
        echo stripslashes(_STORE_META_FREE_META);
	}

	// function inspired from http://at.php.net/get_html_translation_table 04-jun-2007
	function unhtmlentities ($string)  {
		$ret = html_entity_decode($string, ENT_QUOTES, "UTF-8");
		return $ret;
	}

	function _autoGenerateTags($text) {

	    $text = preg_replace(
        array(
            '@<head[^>]*?>.*?</head>@siu',
            '@<style[^>]*?>.*?</style>@siu',
            '@<script[^>]*?.*?</script>@siu',
            '@<object[^>]*?.*?</object>@siu',
            '@<embed[^>]*?.*?</embed>@siu',
            '@<applet[^>]*?.*?</applet>@siu',
            '@<noframes[^>]*?.*?</noframes>@siu',
            '@<noscript[^>]*?.*?</noscript>@siu',
            '@<noembed[^>]*?.*?</noembed>@siu',
        ),
        array(
            ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
        ),
        $text );

		// remove html
		$text = strip_tags($text);
		$text = $this->unhtmlentities($text);

		$trash = array (
			',',
			'.',
			'(',
			')',
			'[',
			']',
			'{',
			'}',
			"'",
			'"',
			'<',
			'>',
			':',
			'?',
			'!',
			'/',
			'\\',
			'_',
			'+',
			'-',
			'*',
			'=',
			'#',
			'&quot;',
			'&copy;',
			'&gt;',
		    '&nbsp;',
		    '\t',
		    '\r',
		    '\n',
		    '\b',
			'&lt;',chr(10), chr(13), chr(9)


		);

		$text = str_replace($trash, ' ', $text);

		$words = explode(" ", $text);
		$selected = array ();
		$skip = defined('SYSTEM_METATAGS_BLACKLIST') ? constant('SYSTEM_METATAGS_BLACKLIST'):'NODEF_SYSTEM_METATAGS_BLACKLIST';
		$skip = explode(',', $skip);
		foreach ($words as $key => $val) {

			//$val = preg_replace('/[^a-zA-Z0-9_-äÄöÖüÜ]/u', '_', $val);

			if (strlen($val) >= $this->minWordlength && !is_int($val) && !in_array($val, $skip)) {
				if (isset ($selected[$val])) {
					$count = 1;
					$selected[$val]['count']++;
				} else {
					$selected[$val] = array (
						'word' => $val,
						'count' => 1
					);
				}
			}
		}
		$count = array ();
		foreach ($selected as $key => $row) {
			$count[$key] = $row['count'];
		}
		// sort on word count
		array_multisort($count, SORT_DESC, $selected);

		// generate tag
		$tags = array ();
		$length = 0;
		foreach ($selected as $key => $row) {
			if (($length +strlen($row['word']) + 1) < $this->maxMetaKeyLength && $this->maxMetaKeyCount >= count($tags)) {
				$tags[] = $row['word'];
				$length += strlen($row['word']) + 1;
			}
		}
		return implode(',', $tags);
	}
    
    private function _autoGenerateDescription($text){

        // remove html
        $text = strip_tags($text);
        $text = $this->unhtmlentities($text);

        $text = preg_replace(
            array(
                '@<head[^>]*?>.*?</head>@siu',
                '@<style[^>]*?>.*?</style>@siu',
                '@<script[^>]*?.*?</script>@siu',
                '@<object[^>]*?.*?</object>@siu',
                '@<embed[^>]*?.*?</embed>@siu',
                '@<applet[^>]*?.*?</applet>@siu',
                '@<noframes[^>]*?.*?</noframes>@siu',
                '@<noscript[^>]*?.*?</noscript>@siu',
                '@<noembed[^>]*?.*?</noembed>@siu',
            ),
            array(
                ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
            ),
            $text );

        $return_text = '';
        $words = explode(" ", $text);
        foreach($words as $k =>$v){
            if(strlen($return_text) > 165){
                break;
            }
            $return_text = $return_text.trim($v).' ';
        }
        return trim($return_text);
    }
}