Ext.namespace("Ext.ux.form");

if(froalaLoadOnFocusOnly === true) // aus ejsadmin.php
{
    //console.log('froala onFocus version', froalaLoadOnFocusOnly);

    Ext.ux.form.FroalaEditor = Ext.extend(Ext.form.TextArea,  {

        initComponent: function(){},

        onFocus : function(ct, position)
        {
            froala_editorInit(this, ct, position);
            Ext.form.TextArea.superclass.onFocus.call(this, ct, position);
        }
    });
}
else {

    //console.log('froala afterRender version', froalaLoadOnFocusOnly);

    Ext.ux.form.FroalaEditor = Ext.extend(Ext.form.TextArea,  {

        initComponent: function(){},

        afterRender : function(ct, position)
        {
            froala_editorInit(this, ct, position);
            Ext.form.TextArea.superclass.afterRender.call(this, ct, position);
        }
    });
}

Ext.reg('froalaeditor', Ext.ux.form.FroalaEditor);


function froala_editorInit(sb, ct, position)
{
    if (!sb.el) {
        sb.defaultAutoCreate = {
            tag: "textarea",
            style: "width:100px;height:60px;",
            autocomplete: "off"
        }
    }

    const _id = '#'+sb.id;

    let xtClass = null;
    let textarea = null;
    let dom = ct.dom;
    if(!froalaLoadOnFocusOnly)
    {
        textarea = dom.childNodes[0];
    }
    else {
        textarea = sb.el.dom;
    }

    if(textarea)
    {
        textarea.classList.forEach(cls => {
            if(cls.startsWith("xtclass-"))
            {
                xtClass = cls.split('-')[1];
            }
        })
    }

    sb.editor = new FroalaEditor(
        _id,
        {
            //enter: FroalaEditor.ENTER_DIV,

            fontSize: ['8', '9', '10', '11', '12', '14', '18', '24', '30', '36', '48', '60', '72', '96'],

            heightMin: froalaHeightMin, // aus ejsadmin.php
            heightMax: froalaHeightMax, // aus ejsadmin.php

            language: froalaLanguage || 'en',

            pastePlain: froalaPastePlain, // aus ejsadmin.php

            iframe: true,

            imageUploadMethod: 'POST',
            imageUploadURL: froala_SRV_WEB + 'froala_upload_image.php', // froala_SRV_WEBaus ejsadmin.php
            imageUploadParams: {
                currentType: 'image',
                xtClass: xtClass
            },
            imageManagerLoadURL: froala_SRV_WEB + 'froala_get_images.php?xtClass=' + xtClass,


            imageManagerDeleteMethod: 'POST',
            imageManagerDeleteParams: {
                currentType: 'image',
                xtClass: xtClass
            },
            imageManagerDeleteURL: froala_SRV_WEB + 'froala_delete_image.php?xtClass=' + xtClass,


            fileUploadMethod: 'POST',
            fileUploadURL: froala_SRV_WEB + 'froala_upload_file.php',
            fileUploadParams: {
                currentType: 'file',
                xtClass: xtClass
            },



            //videoAllowedProviders: ['youtube', 'vimeo'], // default is ['.*']
            //videoAllowedTypes: ['mp4', 'webm', 'ogg'],  // ist default
            videoDefaultAlign: 'left',
            videoDefaultDisplay: 'inline',
            videoResponsive: true,
            videoUploadMethod: 'POST',
            videoUploadURL: froala_SRV_WEB + 'froala_upload_video.php',
            videoUploadParams: {
                currentType: 'video',
                xtClass: xtClass
            },

            linkAutoPrefix: 'https://',

            toolbarButtons: {
                'moreText': {
                    'buttons': ['bold', 'italic', 'underline', 'strikeThrough', 'subscript', 'superscript', 'fontFamily', 'fontSize', 'textColor', 'backgroundColor', 'inlineClass', 'inlineStyle', 'clearFormatting']
                },
                'moreParagraph': {
                    'buttons': ['alignLeft', 'alignCenter', 'formatOLSimple', 'alignRight', 'alignJustify', 'formatOL', 'formatUL', 'paragraphFormat', 'paragraphStyle', 'lineHeight', 'outdent', 'indent', 'quote']
                },
                'moreRich': {
                    'buttons': ['insertLink', 'insertImage', 'insertVideo', 'insertTable', 'emoticons', 'fontAwesome', 'specialCharacters', 'embedly', 'insertFile', 'insertHR']
                },
                'moreMisc': {
                    'buttons': ['undo', 'redo', 'fullscreen', 'print', 'getPDF', 'spellChecker', 'selectAll', 'html', 'help']
                }
            },

            events: {
                'image.inserted_____': $img => {

                    // console.log('image.inserted', $img, this);
                    // bringt uns nix bei schon bestehenden ck bildern ?
                    // oder eben doch für die neu eingefügten
                },
                'image.resized': $img => {

                     console.log('image.resized', $img, this);
                },
                'html.get': html => {
                    //console.log('html.get', html, this);
                    let doUpdate = false;
                    let el = froala_createElementFromHTML(html);
                    el.querySelectorAll("img").forEach( img => {
                        let w = img.style.width.toString()
                        img.style.setProperty("width", w, "important");

                        if(!img.parentElement.classList.contains("fr-view"))
                        {
                            let div = document.createElement("div");
                            div.classList.add("fr-view");

                            img.parentNode.appendChild(div);

                            div.appendChild(img);

                            doUpdate = true;
                        }
                    });

                    // laut doku sollte der return wert übernommen werden, funzt nich
                    // daher das set, denke, dass ist nich so gut
                    // liegt dass daran, dass wir im ext sind ? und this nicht der editor ist
                    if(doUpdate)
                        sb.editor.html.set(el.innerHTML);

                    // return 'html.get test';
                }
            },
            key: "iTB2xC5C1C1A1C3E1B2pZGCTRSAPJWTLPLZHTQQb1JGZxE2F2G2H1B10B2A1E6D1F2==",
            attribution: false,
        }
    );
}

FroalaEditor.PLUGINS['fixPasteBug'] = function (editor) {

    console.log('fixPasteBug');
    // Fix froala's `id="isPasted"` being added during paste event, potentially causing accessibility and duplicate render issues.
    // https://github.com/froala/wysiwyg-editor/issues/4328
    return {
        _init() {
            editor.events.on('paste.after', () => {
                console.log('froala paste.after')
                editor.selection.save();
                const t = document.createElement('template');
                t.innerHTML = editor.html.get(true);
                const offenders = t.content.querySelectorAll('#isPasted');
                offenders.forEach(el => el.removeAttribute('id'));
                editor.html.set(t.innerHTML);
                // restore is required after calling editor.selection.save(), otherwise onModelChange won't trigger
                editor.selection.restore();
            });
        },
    };
};


function froala_createElementFromHTML(htmlString) {
    const div = document.createElement('div');
    div.innerHTML = htmlString.trim();

    // Change this to div.childNodes to support multiple top-level nodes.
    return div;
}

